	/*************************************************************************
*    CompuCell - A software framework for multimodel simulations of     *
* biocomplexity problems Copyright (C) 2003 University of Notre Dame,   *
*                             Indiana                                   *
*                                                                       *
* This program is free software; IF YOU AGREE TO CITE USE OF CompuCell  *
*  IN ALL RELATED RESEARCH PUBLICATIONS according to the terms of the   *
*  CompuCell GNU General Public License RIDER you can redistribute it   *
* and/or modify it under the terms of the GNU General Public License as *
*  published by the Free Software Foundation; either version 2 of the   *
*         License, or (at your option) any later version.               *
*                                                                       *
* This program is distributed in the hope that it will be useful, but   *
*      WITHOUT ANY WARRANTY; without even the implied warranty of       *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
*             General Public License for more details.                  *
*                                                                       *
*  You should have received a copy of the GNU General Public License    *
*     along with this program; if not, write to the Free Software       *
*      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
*************************************************************************/



#include <CompuCell3D/Potts3D/CellInventory.h>
#include <CompuCell3D/Automaton/Automaton.h>

#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Field3D/Point3D.h>
#include <CompuCell3D/steppables/PDESolvers/DiffusableVector.h>
#include <CompuCell3D/Field3D/Field3D.h>
#include <CompuCell3D/Field3D/Field3DImpl.h>
#include <CompuCell3D/Field3D/WatchableField3D.h>
#include <CompuCell3D/plugins/PixelTracker/PixelTrackerPlugin.h>

using namespace CompuCell3D;
#include <BasicUtils/BasicString.h>
#include <BasicUtils/BasicException.h>
#include <BasicUtils/BasicClassAccessor.h>
#include <PublicUtilities/StringUtils.h>
#include <string>
#include <fstream>
#include <sstream>
#include <map>

using namespace std;


#define EXP_STL

#include "SaveCellField.h"

SaveCellField::SaveCellField(){};

SaveCellField::~SaveCellField(){}


void SaveCellField::init(Simulator *_simulator, CC3DXMLElement *_xmlData){
	cout << "************************\n";
	cout << "INITIATE SaveCellField\n";
	sim=_simulator;
	potts = _simulator->getPotts();
	cellInventoryPtr = & potts->getCellInventory();
	cellfield = (WatchableField3D<CellG *> *)potts->getCellFieldG();
	update(_xmlData,true);
}

void SaveCellField::start(){}

void SaveCellField::step(const unsigned int currentStep) {
//	cout << "Save cell field for step " << currentStep << endl;
	if (currentStep < startat) return;
	ostringstream str;
	str<<baseName<<"_CF_"<<currentStep+offset<<".data";
	ofstream fileC(str.str().c_str());
	str.str("");
        str<<baseName<<"_SF_"<<currentStep+offset<<".data";
	ofstream fileS(str.str().c_str());
	str.str("");
	str<<baseName<<"_TF_"<<currentStep+offset<<".data";
	ofstream fileT(str.str().c_str());
	map<string,Field3DImpl<float>*>::iterator it;
	map<string,ofstream*>::iterator cit;
	map<string,ofstream*> cfiles;
	ofstream file;
	if ((currentStep % fieldfreq) == 0){
		for ( it=fieldmap.begin() ; it != fieldmap.end(); it++ ){
			ostringstream fname;
			fname<<baseName<<"_"<<(*it).first<<"_"<<currentStep<<".data";
			//~ cout << "save field "<<(*it).first<<" to "<<fname.str()<<endl;
			cfiles[(*it).first] = new ofstream(fname.str().c_str());
			cfiles[(*it).first]->precision(prec);
			//~ file.open(fname.str().c_str());
			//~ file.precision(prec);
		}
	}
	Point3D pt;
	for (pt.y = 0; pt.y < cellfield->getDim().y; ++pt.y){
		for (pt.x = 0; pt.x < cellfield->getDim().x; ++pt.x){
			if (cellfield->get(pt)){
				fileC << (int)(cellfield->get(pt)->clusterId) << " ";
                                fileS << (int)(cellfield->get(pt)->id) << " ";
				fileT << (int)(cellfield->get(pt)->type) << " ";
			}
			else{
				fileC << "0 ";
                                fileS << "0 ";
				fileT << "0 ";
			}
			for ( cit=cfiles.begin() ; cit != cfiles.end(); cit++ )
                            {
                                if (fieldmap[(*cit).first]->get(pt)>=0)
                                    *(*cit).second << fieldmap[(*cit).first]->get(pt) << " ";
                                else //so diffusion crashed and gives nan, I want 0.0 there
                                    {
                                    *(*cit).second << "0.0" << " ";
                                    }
                                //cerr<<"value="<<fieldmap[(*cit).first]->get(pt)<<endl;
//				*(*cit).second << sprintf("","%.3f",fieldmap[(*cit).first]->get(pt)) << " ";
                            }
		}
		fileC << "\n";
                fileS << "\n";
		fileT << "\n";
		for ( cit=cfiles.begin() ; cit != cfiles.end(); cit++ )
			*(*cit).second << "\n";
	}
//	cout << fileC.is_open() << endl;
	fileC.close();
        fileS.close();
	fileT.close();
	for ( cit=cfiles.begin() ; cit != cfiles.end(); cit++ ){
		(*(*cit).second).close();
		//~ delete (*(*cit).second);
	}
}

void SaveCellField::finish(){}

void SaveCellField::update(CC3DXMLElement *_xmlData, bool _fullInitFlag){
	CC3DXMLElement *dataXMLElement=_xmlData->getFirstElement("BaseName");
	ASSERT_OR_THROW("You must provide a base for the filenames!", dataXMLElement);
	baseName = dataXMLElement->getText();
	offset = 0;
	startat = 0;
	if (_xmlData->findElement("MCSOffset"))
		offset = _xmlData->getFirstElement("MCSOffset")->getInt();
	if (_xmlData->findElement("StartAt"))
		startat = _xmlData->getFirstElement("StartAt")->getInt();
	if (_xmlData->findElement("SaveConcentrationFields")){
		cout << "SAVE FIELDS!" << endl;
		string text = _xmlData->getFirstElement("SaveConcentrationFields")->getText();
		map<string,Field3DImpl<float>*> cc3dFieldMap = sim->getConcentrationFieldNameMap();
		if ((int)text.size() > 0){
			std::vector<std::string> fields;
			parseStringIntoList(text,fields, ",");
			for (int i=0; i < (int)fields.size(); i++){
				if (cc3dFieldMap.find(fields[i]) != cc3dFieldMap.end()){
					fieldmap[fields[i]] = cc3dFieldMap[fields[i]];
					cout << "Save field " << fields[i] << endl;
				}
				else
					cout << "Field " << fields[i] << " is unknown!!!!!!!!!!!!!!!!!!!!!!!!\n";			
			}
		}
		else
			fieldmap = cc3dFieldMap;
		CC3DXMLElement *data = _xmlData->getFirstElement("SaveConcentrationFields");
		if (data->findAttribute("Precision")){ prec = data->getAttributeAsInt("Precision");}
		else { prec=3;}
		if (data->findAttribute("Frequency")){ fieldfreq = data->getAttributeAsInt("Frequency");}
		else { fieldfreq = frequency;}
	}
	else{
		prec=3;
		fieldfreq = frequency;
	}
}
	
std::string SaveCellField::toString(){return "SaveCellField";}





